/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#ifndef LASTERR_H
#define LASTERR_H

/*
// The include file for displaying the last windows error.
// If you wish to display only in debug mode then use the macro defined 
// below, otherwise use "DispLastError();" if you don't want the filename
// and line number.

// ** If you don't want the messages in a message box then 
//    define SEND_ERR_DBG_WINDOW at compile time
*/

#ifndef _DEBUG
#   ifdef   BEST_DEBUG
#       define _DEBUG
#   endif
#endif

#if (defined(_WIN32) || defined(_WIN64)) && !defined(_DOS) 

#pragma warning( disable: 4115 4514)
#include <windows.h>
#pragma warning( default: 4115)

#include <stdio.h>
#include <defines.h>    /* Best CAPI include file */


void EXPORT DisplayLastError( PVOID pFileName,
                              ULONG uLineNumber,
                              LONG lErrNum,
                              BOOLEAN fOutputToVC
                            );

#define DispLastError()  DisplayLastError(NULL, 0, 0)

#ifdef _DEBUG

#       include <winbase.h>
#       include <winuser.h>


/* send all output to the Developer Studio Debug Window */
#define _DBG_WINDOW TRUE

#   define DBG_PRINT(msg) OutputDebugString((msg))
/*
#   ifdef SEND_ERR_DBG_WINDOW
#       define _DBG_WINDOW TRUE
#   else
#       define _DBG_WINDOW FALSE
#   endif
*/

/* for API calls returning void (or cast to void) */
#   define DBG_ApiLastError  DisplayLastError( __FILE__, __LINE__, 0, _DBG_WINDOW )

/* for API calls returning an error code where 0 is success (ERROR_SUCCESS is 0!!) */
#   define DBG_ApiSuccessIsZero(lErrNum)  \
            if(lErrNum) \
                DisplayLastError( __FILE__, __LINE__, lErrNum, _DBG_WINDOW )

/* for API calls returning 0 on failure (i.e. BOOL) */
#   define DBG_ApiFailureIsZero(lErrNum)  \
            if(!lErrNum) \
                DisplayLastError( __FILE__, __LINE__, 0, _DBG_WINDOW )

/* just a friendly msg in debug mode */
#   define  HELLO_BEST  "\nWindows API error detected at...\n\n"

#else   /* Release version */

#   define DBG_ApiLastError
#   define DBG_ApiSuccessIsZero(lErrNum)
#   define DBG_ApiFailureIsZero(lErrNum)
#   define  HELLO_BEST  "\n\n"
#   define DBG_PRINT(msg)

#endif  /* DBG */

#else   /* NOT _WIN32 */

#   define DBG_ApiLastError
#   define DBG_ApiSuccessIsZero(lErrNum)
#   define DBG_ApiFailureIsZero(lErrNum)
#   define HELLO_BEST  "\n\n"
#   define DBG_PRINT(msg)

#endif  /* _WIN32 */



#endif  /* LASTERR_H */
